/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.registry;

import com.zurrtum.create.catnip.data.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;

public interface CreateRegisterPlugin {
    public static final List<CreateRegisterPlugin> PLUGINS = CreateRegisterPlugin.createPlugins();

    default public void onBlockRegister() {
    }

    default public void onFluidRegister() {
    }

    default public void onDataLoaderRegister() {
    }

    default public void onEntityAttributeRegister() {
    }

    public static List<CreateRegisterPlugin> createPlugins() {
        List list = FabricLoader.getInstance().getEntrypointContainers("create_plugin", CreateRegisterPlugin.class);
        ArrayList<Pair<String, CreateRegisterPlugin>> entries = new ArrayList<Pair<String, CreateRegisterPlugin>>(list.size());
        Comparator<Pair> pluginComparator = Comparator.comparing(pair -> !((String)pair.getFirst()).equals("create")).thenComparing(Pair::getFirst);
        for (EntrypointContainer container : list) {
            Pair<String, CreateRegisterPlugin> plugin = Pair.of(container.getProvider().getMetadata().getId(), (CreateRegisterPlugin)container.getEntrypoint());
            int index = Collections.binarySearch(entries, plugin, pluginComparator);
            int insertionPoint = index >= 0 ? index : -index - 1;
            entries.add(insertionPoint, plugin);
        }
        return entries.stream().map(Pair::getSecond).toList();
    }

    public static void registerBlock() {
        PLUGINS.forEach(CreateRegisterPlugin::onBlockRegister);
    }

    public static void registerFluid() {
        PLUGINS.forEach(CreateRegisterPlugin::onFluidRegister);
    }

    public static void registerDataLoader() {
        PLUGINS.forEach(CreateRegisterPlugin::onDataLoaderRegister);
    }

    public static void registerEntityAttributes() {
        PLUGINS.forEach(CreateRegisterPlugin::onEntityAttributeRegister);
    }
}

